function [obj] = compute_neocc_obj2(X,U,V,ver)

assert(size(U,1)>=size(U,2),'U should be n by k.');
assert(size(V,1)>=size(V,2),'V should be m by l.');

%% filter out empty clusters
U = U(:,sum(U)>0);
V = V(:,sum(V)>0);

k=size(U,2);
l=size(V,2);
obj=0;
for i=1:k
    for j=1:l
        ui = U(:,i);
        vj = V(:,j);
        uhat = ui/sqrt(nnz(ui));
        vhat = vj/sqrt(nnz(vj));
        if strcmp(ver,'v1')
            obj = obj + norm(diag(ui)*X*diag(vj) - uhat*(uhat')*X*vhat*(vhat'),'fro')^2;
        elseif strcmp(ver,'v2')
            obj = obj + norm(diag(ui)*X*diag(vj) - uhat*(uhat')*X*diag(vj) - diag(ui)*X*vhat*(vhat')...
                + uhat*(uhat')*X*vhat*(vhat'),'fro')^2;
        else
            fprintf('Invalid option!');
        end
    end
end

end