function [U,V,J_track] = neo_cc2(X,k,l,alpha_r,beta_r,alpha_c,beta_c,initU,initV,ver)

%% Initialize variables
N = size(X,1);   
M = size(X,2); 
U = initU;       
V = initV;
t=0;
t_max=100;
JJ=Inf;
oldJJ=0;
epsilon=0;
J_track=[];

fprintf('********** NEO-CC **********\n');
%% Initial obj
J=compute_neocc_obj2(X,U,V,ver);
fprintf('***** Initial NEO-CC obj: %6.6f\n',J);
J_track=[J_track; JJ];
while abs(oldJJ-JJ)>epsilon && t<=t_max
    oldJJ=JJ;
    %J=0;
       
    %% /*---------------------------- Update Row Clustering ----------------------------*/ 
    % Compute distance
    Dr=zeros(N,k);
    for q=1:k
        uq = U(:,q);
        uqhat = uq/sqrt(nnz(uq));
        for j=1:l
            vj = V(:,j);
            vjhat = vj/sqrt(nnz(vj));
            if nnz(uq)~=0 && nnz(vj)~=0
                if strcmp(ver,'v1')
                    cq = sqrt(1/nnz(uq))*(uqhat')*X*(vjhat)*(vjhat');
                    dq = X*diag(vj) - repmat(cq,N,1);      
                    Dr(:,q)=Dr(:,q)+sum(dq.^2,2);
                elseif strcmp(ver,'v2')
                    cq = sqrt(1/nnz(uq))*(uqhat')*X*(diag(vj)-(vjhat)*(vjhat'));
                    dq = X*(diag(vj)-(vjhat)*(vjhat')) - repmat(cq,N,1);
                    Dr(:,q)=Dr(:,q)+sum(dq.^2,2);
                else
                    fprintf('Invalid option!');
                end
            end
        end
    end
    % Make assignments
    [U,dJ] = make_assignments(Dr,N,k,alpha_r,beta_r);
    %J = J + dJ;
    fprintf('***** iteration: %d (row update), objective: %6.12f\n',t,dJ);
    JJ=compute_neocc_obj2(X,U,V,ver);
    fprintf('***** iteration: %d (row update), NEO-CC obj: %6.12f\n',t,JJ);
    J_track=[J_track; JJ];
    %full(U)
    
    %% /*---------------------------- Update Column Clustering ----------------------------*/
    % Compute distance
    Dc=zeros(M,l);
    for q=1:l
        vq = V(:,q);
        vqhat = vq/sqrt(nnz(vq));
        for i=1:k
            ui = U(:,i);
            uihat = ui/sqrt(nnz(ui));
            if nnz(vq)~=0 && nnz(ui)~=0
                if strcmp(ver,'v1')
                    cq = sqrt(1/nnz(vq))*(uihat)*(uihat')*X*(vqhat);
                    dq = diag(ui)*X - repmat(cq,1,M); 
                    dq = dq';
                    Dc(:,q)=Dc(:,q)+sum(dq.^2,2);
                elseif strcmp(ver,'v2')
                    cq = sqrt(1/nnz(vq))*(diag(ui)-(uihat)*(uihat'))*X*(vqhat);
                    dq = (diag(ui)-(uihat)*(uihat'))*X - repmat(cq,1,M); 
                    dq = dq';
                    Dc(:,q)=Dc(:,q)+sum(dq.^2,2);
                else
                    fprintf('Invalid option!');
                end
            end
        end
    end
    % Make assignments
    [V,dJ] = make_assignments(Dc,M,l,alpha_c,beta_c);
    %J = J + dJ;
    fprintf('***** iteration: %d (column update), objective: %6.12f\n',t,dJ);
    JJ=compute_neocc_obj2(X,U,V,ver);
    fprintf('***** iteration: %d (column update), NEO-CC obj: %6.12f\n',t,JJ);
    %full(V)
    
    t=t+1;
    J_track=[J_track; JJ];
end
fprintf('***** No. of iterations done: %d\n',t);


%% display results
fprintf('***** (ROW) Total no. of data points: %d \n',N);
fprintf('***** (ROW) alpha_r: %3.3f, alphaN_r: %d \n',alpha_r,round(alpha_r*N));
fprintf('***** (ROW) beta_r: %3.3f, betaN_r: %d \n',beta_r,round(beta_r*N));
fprintf('***** (COL) Total no. of data points: %d \n',M);
fprintf('***** (COL) alpha_c: %3.3f, alphaM_c: %d \n',alpha_c,round(alpha_c*M));
fprintf('***** (COL) beta_c: %3.3f, betaM_c: %d \n\n',beta_c,round(beta_c*M));

end